<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->tinyInteger('gender')->nullable();
			$table->date('d_o_b');
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->decimal('latitude', 10,8)->nullable();
			$table->decimal('longitude', 10,8)->nullable();
			$table->string('pin_code', 255)->nullable();
			$table->char('google_id', 255);
			$table->char('fb_id', 255);
			$table->string('email_verified_at', 255);
			$table->tinyInteger('terms')->default('0');
			$table->bigInteger('country_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}