<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalAnalysisTable extends Migration {

	public function up()
	{
		Schema::create('medical_analysis', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->text('analysis_for')->nullable();
			$table->text('note');
			$table->integer('medical_analysis_type_id')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->bigInteger('booking_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('medical_analysis');
	}
}