<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->text('content');
			$table->datetime('read_at');
			$table->tinyInteger('is_read')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}