<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('credit_card_number');
			$table->integer('card_holder_name');
			$table->date('expiry_date');
			$table->integer('cvv_code');
			$table->bigInteger('doctor_id')->unsigned();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('payment_method_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}