<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('hashtags', 'title', 'description');
	protected $visible = array('hashtags', 'title', 'description');

	public function post()
	{
		return $this->belongsTo('Post', 'id', 'post_id');
	}

}