<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client', 'imei', 'service', 'price', 'status');
	protected $visible = array('client', 'imei', 'service', 'price', 'status');

	public function status()
	{
		return $this->hasOne('Status', 'id');
	}

}