<?php

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;
	protected $fillable = array('title', 'category', 'description', 'image', 'delivery_time', 'features', 'price', 'supplier', 'external_id');
	protected $visible = array('title', 'category', 'description', 'image', 'delivery_time', 'features', 'price', 'supplier', 'external_id');

	public function features()
	{
		return $this->hasMany('Feature', 'id');
	}

	public function supplier()
	{
		return $this->hasOne('Supplier', 'id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'id');
	}

}