<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('description');
			$table->boolean('active')->default(0);
			$table->integer('duration')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}