<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageItemsTable extends Migration {

	public function up()
	{
		Schema::create('package_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('package_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->mediumInteger('session_count')->default('1');
			$table->enum('price_type', array('free', 'off_percent', 'extra_percent', 'fix_price'));
			$table->decimal('price_value', 15,0);
			$table->decimal('extra_price_value', 15,0)->default('0');
			$table->string('price_currency_code', 5)->nullable();
			$table->enum('session_type', array('duration', 'manual'));
			$table->integer('duration')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('package_items');
	}
}