<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertPackageReservationsTable extends Migration {

	public function up()
	{
		Schema::create('expert_package_reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('host_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('expert_id')->unsigned();
			$table->integer('expert_package_id')->unsigned();
			$table->string('package_name');
			$table->decimal('actual_cost', 15,0);
			$table->decimal('discount_cost', 15,0);
			$table->decimal('final_cost', 15,0);
			$table->integer('used_voucher_id')->nullable();
			$table->integer('user_transaction_id');
			$table->integer('currency_code');
			$table->enum('status', array('create', 'waiting_for_payment', 'reserved', 'accepted', 'rejected', 'canceled', 'done'));
			$table->datetime('start_time')->nullable();
			$table->datetime('end_time')->nullable();
			$table->timestamps();
			$table->boolean('immideiatly')->default(0);
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('expert_package_reservations');
	}
}