<?php

namespace Local;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Zone extends Eloquent {

	protected $table = 'local_zones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('level', 'zid', 'parent', 'hasc', 'code', 'type', 'name', 'population');

	public function center()
	{
		return $this->hasOne('Local\Zone', 'zid', 'name');
	}

	public function members()
	{
		return $this->hasMany('Local\Zone', 'zid', 'name');
	}

	public function languages()
	{
		return $this->hasMany('Local\ZoneLanguage', 'code', 'ratio');
	}

	public function currencies()
	{
		return $this->hasMany('Local\ZoneCurrency', 'code', 'ratio');
	}

	public function incomes()
	{
		return $this->hasMany('Local\ZoneIncome', 'id', 'age_range', 'money', 'ratio');
	}

	public function populations()
	{
		return $this->hasMany('Local\ZonePopulation', 'id', 'age_range', 'number', 'ratio');
	}

	public function educations()
	{
		return $this->hasMany('Local\ZoneEducation', 'level', 'ratio');
	}

	public function orgs()
	{
		return $this->hasMany('Local\ZoneOrg', 'oid', 'logo', 'brandname', 'type', 'name', 'link');
	}

	public function peoples()
	{
		return $this->hasMany('Local\ZonePeople', 'pid', 'name', 'email', 'picture', 'profile');
	}

	public function places()
	{
		return $this->hasMany('Local\Place', 'id', 'lat', 'lon', 'timezone');
	}

	public function addresses()
	{
		return $this->hasMany('Local\Address', 'id', 'sortname');
	}

	public function shapes()
	{
		return $this->hasMany('Local\ZoneShape', 'lat', 'lon');
	}

	public function products()
	{
		return $this->hasMany('Local\ZoneProduct', 'id', 'name', 'picture', 'link');
	}

	public function links()
	{
		return $this->hasMany('Link\Link', 'id', 'url', 'title');
	}

	public function media()
	{
		return $this->hasMany('Local\LocationGeo', 'id', 'type', 'uri');
	}

	public function tags()
	{
		return $this->hasMany('Local\LocationGeo', 'tid', 'text');
	}

}