<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->text('desc');
			$table->integer('user_id');
			$table->integer('size');
			$table->integer('ad_type_id');
			$table->integer('ad_status_id');
			$table->decimal('price', 5,2);
			$table->integer('city_id');
			$table->integer('category_id');
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}