<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tenant01_tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('tenant01_users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenant02_tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('tenant02_users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('tenant01_tasks', function(Blueprint $table) {
			$table->dropForeign('tenant01_tasks_user_id_foreign');
		});
		Schema::table('tenant02_tasks', function(Blueprint $table) {
			$table->dropForeign('tenant02_tasks_user_id_foreign');
		});
	}
}