<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('job_applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('job_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('linkedin_url');
			$table->integer('city_id')->unsigned();
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('job_applications');
	}
}