<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('sponsorship_type_id')->references('id')->on('sponsorship_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->foreign('program_type_id')->references('id')->on('program_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->foreign('certificate_type_id')->references('id')->on('certificate_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('certificate_type_id')->references('id')->on('certificate_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('course_program', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('coures')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('course_program', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('programs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('job_applications', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('job_applications', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('genders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('ssn_district_id')->references('id')->on('districts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('school_district_id')->references('id')->on('districts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('school_city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('secondary_certificate_type_id')->references('id')->on('secondary_certificate_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('program_training_application', function(Blueprint $table) {
			$table->foreign('training_application_id')->references('id')->on('training_applications')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('program_training_application', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('programs')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_sponsorship_type_id_foreign');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->dropForeign('programs_program_type_id_foreign');
		});
		Schema::table('programs', function(Blueprint $table) {
			$table->dropForeign('programs_certificate_type_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_certificate_type_id_foreign');
		});
		Schema::table('course_program', function(Blueprint $table) {
			$table->dropForeign('course_program_course_id_foreign');
		});
		Schema::table('course_program', function(Blueprint $table) {
			$table->dropForeign('course_program_program_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_language_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_category_id_foreign');
		});
		Schema::table('job_applications', function(Blueprint $table) {
			$table->dropForeign('job_applications_job_id_foreign');
		});
		Schema::table('job_applications', function(Blueprint $table) {
			$table->dropForeign('job_applications_city_id_foreign');
		});
		Schema::table('districts', function(Blueprint $table) {
			$table->dropForeign('districts_city_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_gender_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_ssn_district_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_school_district_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_school_city_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_secondary_certificate_type_id_foreign');
		});
		Schema::table('training_applications', function(Blueprint $table) {
			$table->dropForeign('training_applications_company_id_foreign');
		});
		Schema::table('program_training_application', function(Blueprint $table) {
			$table->dropForeign('program_training_application_training_application_id_foreign');
		});
		Schema::table('program_training_application', function(Blueprint $table) {
			$table->dropForeign('program_training_application_program_id_foreign');
		});
	}
}