<?php

namespace App\Models;

class District extends Eloquent {

	protected $table = 'districts';
	public $timestamps = true;
	protected $fillable = array('name', 'city_id');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function trainApplicationSsns()
	{
		return $this->hasMany('App\Models\TrainingApplication', 'ssn_district_id');
	}

	public function trainApplicationSchools()
	{
		return $this->hasMany('App\Models\TrainingApplication', 'school_district_id');
	}

}