<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name');
			$table->json('bio')->nullable();
			$table->json('position')->nullable();
			$table->enum('role', array(''));
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}