<?php

namespace App\Models;

class Program extends Eloquent {

	protected $table = 'programs';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'credit_hours', 'cooperative_hours', 'duration', 'work_fields', 'program_type_id', 'certificate_type_id');

	public function type()
	{
		return $this->belongsTo('App\Models\ProgramType');
	}

	public function certificateType()
	{
		return $this->belongsTo('App\Models\CertificateType');
	}

	public function courses()
	{
		return $this->hasMany('App\Models\Course');
	}

	public function trainingApplications()
	{
		return $this->belongsToMany('App\Models\TrainingApplication');
	}

}