<?php

namespace App\Models;

class TrainingApplication extends Eloquent {

	protected $table = 'training_applications';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'relevant_phone', 'iban', 'gender_id', 'birthdate', 'ssn', 'ssn_issue_date', 'number', 'school_district_id', 'school_name', 'school_city_id', 'secondary_certificate_type_id', 'secondary_gpa', 'aptitude_test_score', 'comment', 'company_id', 'status');
	protected $visible = array('ssn_district_id');

	public function ssnDistrict()
	{
		return $this->belongsTo('App\Models\District', 'ssn_district_id');
	}

	public function schoolDistrict()
	{
		return $this->belongsTo('App\Models\District', 'school_district_id');
	}

	public function schoolCity()
	{
		return $this->belongsTo('App\Models\City', 'school_city_id');
	}

	public function secondaryCertificateType()
	{
		return $this->belongsTo('App\Models\SecondaryCertificateType', 'secondary_certificate_type_id');
	}

	public function company()
	{
		return $this->belongsTo('App\Models\Company');
	}

	public function programs()
	{
		return $this->belongsToMany('App\Models\Program');
	}

	public function gender()
	{
		return $this->belongsTo('App\Models\Gender');
	}

}