<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name');
			$table->json('description');
			$table->integer('credit_hours');
			$table->integer('cooperative_hours');
			$table->json('duration');
			$table->json('work_fields')->nullable();
			$table->integer('program_type_id')->unsigned();
			$table->integer('certificate_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}