<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('content_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('content_id')->unsigned();
			$table->string('locale')->unique();
			$table->string('name', 100)->nullable();
			$table->text('description')->nullable();
			$table->text('keywords')->nullable();
			$table->text('content')->nullable()->default('255');
		});
	}

	public function down()
	{
		Schema::drop('content_translations');
	}
}