<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->increments('order');
			$table->string('type', 100)->nullable();
			$table->boolean('status')->default(1);
			$table->string('slug', 100)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}