<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->increments('order');
			$table->string('name', 100)->nullable();
			$table->text('description')->nullable();
			$table->string('file', 255)->nullable();
			$table->boolean('status')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}