<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('category_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('locale')->unique();
			$table->string('name', 100)->nullable();
			$table->text('description')->nullable();
			$table->text('keywords')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('category_translations');
	}
}