<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;
	protected $fillable = array('phone', 'email', 'password', 'name', 'd_o_b', 'last_donation_date', 'city_id', 'pin_code');

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function governorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function bloodTypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function BloodTypes()
	{
		return $this->hasMany('App\Models\BloodType');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

}