<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('author_id')->unsigned();
			$table->text('title');
			$table->text('description');
			$table->string('slug')->nullable();
			$table->string('content');
			$table->string('url_to_image')->nullable();
			$table->string('url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}