<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->integer('advertisement_id');
			$table->integer('package_type');
			$table->integer('payment_type');
			$table->text('ref_no');
			$table->datetime('expiration_date');
			$table->boolean('expired');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}