<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->text('phone');
			$table->text('address')->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password', 255)->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->integer('country_id');
			$table->integer('type');
			$table->text('website');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}