<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SyncData extends Eloquent {

	protected $table = 'sync_data';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function dealer()
	{
		return $this->hasOne('App\Models\User');
	}

	public function frequency()
	{
		return $this->hasOne('App\Models\CronFrequency', 'cron_id');
	}

}