<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrenciesTable extends Migration {

	public function up()
	{
		Schema::create('currencies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('currency_code', 10);
			$table->string('name', 255);
			$table->string('symbol', 25);
			$table->string('format', 50);
			$table->string('exchange_rate', 255);
			$table->tinyInteger('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('currencies');
	}
}