<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Advertisement extends Eloquent {

	protected $table = 'advertisements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->hasOne('App\Models\Category', 'category_id');
	}

	public function details()
	{
		return $this->hasMany('App\Models\AdvertisementDetails', 'advertisement_id');
	}

	public function images()
	{
		return $this->hasMany('App\Models\AdvertisementImages', 'advertisement_id');
	}

	public function brand()
	{
		return $this->hasOne('App\Models\Brand', 'brand_id');
	}

	public function advertisement_categories()
	{
		return $this->hasMany('App\Models\AdvertisementCategory', 'advertisement_id');
	}

	public function subcategory()
	{
		return $this->hasOne('App\Models\SubCategory', 'opbygning');
	}

	public function currency()
	{
		return $this->hasOne('App\Models\Currency', 'currency_id');
	}

	public function payment()
	{
		return $this->hasOne('App\Models\Payments');
	}

}