<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id', true);
			$table->bigInteger('entity_id')->unsigned()->index();
			$table->bigInteger('customer_type_id')->unsigned()->index();
			$table->bigInteger('customer_class_id')->unsigned()->index();
			$table->string('email')->unique();
			$table->tinyInteger('status')->unsigned();
			$table->tinyInteger('main_entity_available');
			$table->tinyInteger('form_contact_user');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('company_name');
			$table->string('phone_number');
			$table->string('cgp_code');
			$table->string('password');
			$table->string('remember_token');
			$table->string('registration_token');
			$table->tinyInteger('is_registered');
			$table->tinyInteger('is_deactivated');
			$table->string('comments');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}