<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubscriptionPeriod extends Eloquent {

	protected $table = 'subscription_periods';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function share()
	{
		return $this->belongsTo('Share');
	}

	public function subscriptions()
	{
		return $this->hasMany('Subscription');
	}

}