<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScooterTable extends Migration {

	public function up()
	{
		Schema::create('scooter', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->string('name', 255);
			$table->string('description', 255);
			$table->integer('base_price');
			$table->integer('autonomy');
			$table->integer('rating');
			$table->integer('rating_counter');
			$table->integer('id_range_base_price')->unsigned();
			$table->integer('id_autonomy')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('scooter');
	}
}