<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('typetest_id')->references('id')->on('typetests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('options', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('typeresult_id')->references('id')->on('typeresults')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('retros', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('retros', function(Blueprint $table) {
			$table->foreign('result_id')->references('id')->on('results')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('userlogins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('explanations', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_course_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_module_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_lesson_id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_typetest_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_test_id_foreign');
		});
		Schema::table('options', function(Blueprint $table) {
			$table->dropForeign('options_question_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_test_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_user_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_typeresult_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_company_id_foreign');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->dropForeign('assignments_user_id_foreign');
		});
		Schema::table('retros', function(Blueprint $table) {
			$table->dropForeign('retros_user_id_foreign');
		});
		Schema::table('retros', function(Blueprint $table) {
			$table->dropForeign('retros_result_id_foreign');
		});
		Schema::table('userlogins', function(Blueprint $table) {
			$table->dropForeign('userlogins_user_id_foreign');
		});
		Schema::table('explanations', function(Blueprint $table) {
			$table->dropForeign('explanations_test_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_project_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_user_id_foreign');
		});
	}
}