<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('department', function(Blueprint $table) {
			$table->foreign('collage_id')->references('id')->on('collage')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assistant', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->foreign('feedback_model_id')->references('id')->on('feedback_form_model')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assistant_course', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assistant_course', function(Blueprint $table) {
			$table->foreign('assistant_id')->references('id')->on('assistant')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_instructor', function(Blueprint $table) {
			$table->foreign('instructor_id')->references('id')->on('instructor')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('course_instructor', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedback_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedback_student', function(Blueprint $table) {
			$table->foreign('feedback_id')->references('id')->on('feedback')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedback_instructor', function(Blueprint $table) {
			$table->foreign('instructor_id')->references('id')->on('instructor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('feedback_instructor', function(Blueprint $table) {
			$table->foreign('feedback_id')->references('id')->on('feedback')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('department', function(Blueprint $table) {
			$table->dropForeign('department_collage_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_department_id_foreign');
		});
		Schema::table('assistant', function(Blueprint $table) {
			$table->dropForeign('assistant_course_id_foreign');
		});
		Schema::table('feedback', function(Blueprint $table) {
			$table->dropForeign('feedback_feedback_model_id_foreign');
		});
		Schema::table('assistant_course', function(Blueprint $table) {
			$table->dropForeign('assistant_course_course_id_foreign');
		});
		Schema::table('assistant_course', function(Blueprint $table) {
			$table->dropForeign('assistant_course_assistant_id_foreign');
		});
		Schema::table('course_instructor', function(Blueprint $table) {
			$table->dropForeign('course_instructor_instructor_id_foreign');
		});
		Schema::table('course_instructor', function(Blueprint $table) {
			$table->dropForeign('course_instructor_course_id_foreign');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->dropForeign('course_student_course_id_foreign');
		});
		Schema::table('course_student', function(Blueprint $table) {
			$table->dropForeign('course_student_student_id_foreign');
		});
		Schema::table('feedback_student', function(Blueprint $table) {
			$table->dropForeign('feedback_student_student_id_foreign');
		});
		Schema::table('feedback_student', function(Blueprint $table) {
			$table->dropForeign('feedback_student_feedback_id_foreign');
		});
		Schema::table('feedback_instructor', function(Blueprint $table) {
			$table->dropForeign('feedback_instructor_instructor_id_foreign');
		});
		Schema::table('feedback_instructor', function(Blueprint $table) {
			$table->dropForeign('feedback_instructor_feedback_id_foreign');
		});
	}
}