<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCardsTable extends Migration {

	public function up()
	{
		Schema::create('user_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('join_type');
			$table->bigInteger('subscription_request_id')->unsigned();
			$table->date('expiry_date');
			$table->date('start_at');
			$table->string('card_number', 50);
		});
	}

	public function down()
	{
		Schema::drop('user_cards');
	}
}