<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('provider_timings', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('provider_offers', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_cards', function(Blueprint $table) {
			$table->foreign('subscription_request_id')->references('id')->on('subscription_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription_requests', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationalities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription_requests', function(Blueprint $table) {
			$table->foreign('degree_id')->references('id')->on('degrees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('provider_timings', function(Blueprint $table) {
			$table->dropForeign('provider_timings_provider_id_foreign');
		});
		Schema::table('provider_offers', function(Blueprint $table) {
			$table->dropForeign('provider_offers_provider_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_provider_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_provider_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_plan_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('user_cards', function(Blueprint $table) {
			$table->dropForeign('user_cards_subscription_request_id_foreign');
		});
		Schema::table('subscription_requests', function(Blueprint $table) {
			$table->dropForeign('subscription_requests_nationality_id_foreign');
		});
		Schema::table('subscription_requests', function(Blueprint $table) {
			$table->dropForeign('subscription_requests_degree_id_foreign');
		});
	}
}