<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50)->nullable();
			$table->string('phone', 50);
			$table->string('image', 50)->nullable();
			$table->string('email', 50)->nullable();
			$table->enum('gender', array('0', '1'));
			$table->enum('is_complete', array('0', '1'));
			$table->enum('is_notify', array('0', '1'));
			$table->string('lat')->nullable();
			$table->string('lng');
			$table->string('map_desc');
			$table->string('wallet');
			$table->string('is_blocked');
			$table->string('code');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}