<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone', 50);
			$table->string('name', 50);
			$table->integer('avg_rate')->default('0');
			$table->string('map_desc', 50);
			$table->string('lat', 50);
			$table->string('lng', 50);
			$table->integer('num_of_branches');
			$table->double('avg_count')->default('0');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}