<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('plan_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->double('price');
			$table->integer('payment_type');
			$table->integer('payment_status');
			$table->integer('status');
			$table->date('start_at');
			$table->integer('end_at');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}