<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiAssetCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('fi_asset_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->nullable();
			$table->text('note')->nullable();
			$table->boolean('status')->nullable();
			$table->string('refrence_number', 100)->nullable();
			$table->integer('system_account_id')->unsigned()->nullable();
			$table->boolean('is_depreciable')->nullable();
			$table->double('depreciable_rate')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fi_asset_categories');
	}
}