<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiAssetsTable extends Migration {

	public function up()
	{
		Schema::create('fi_assets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('refrence_number', 100)->nullable();
			$table->string('name', 100)->nullable();
			$table->integer('asset_category_id')->unsigned()->nullable();
			$table->date('purchase_date')->nullable();
			$table->date('operation_date')->nullable();
			$table->enum('measure_value', array('rs', 'piece'))->nullable();
			$table->enum('tax', array('zerotax', 'exemptfromtax', 'vat'))->nullable();
			$table->string('barcode', 100)->nullable();
			$table->integer('asset_account_id')->unsigned()->nullable();
			$table->double('value')->nullable();
			$table->double('scrap_value')->nullable();
			$table->date('expiration_date')->nullable();
			$table->boolean('is_depreciable')->nullable();
			$table->integer('depreciation_expense_account')->unsigned()->nullable();
			$table->integer('depreciation_collection_account')->unsigned()->nullable();
			$table->boolean('is_warranty')->nullable();
			$table->date('warranty_date')->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fi_assets');
	}
}