<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomesTable extends Migration {

	public function up()
	{
		Schema::create('incomes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('bond_no', 100)->nullable();
			$table->integer('treasury_id')->nullable();
			$table->integer('income_type_id')->unsigned()->nullable();
			$table->enum('dealing', array('Customer', 'AccountCode', 'ServiceProvider'))->nullable();
			$table->integer('Employee_id')->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('vendor_id')->unsigned()->nullable();
			$table->string('iban', 100)->nullable();
			$table->integer('Bank_id')->unsigned()->nullable();
			$table->string('check_number', 100)->nullable();
			$table->date('check_date')->nullable();
			$table->integer('Management_id')->nullable();
			$table->string('income_number', 100)->nullable();
			$table->integer('Instelemnt_id')->unsigned()->nullable();
			$table->double('amount')->nullable();
			$table->json('attachments')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('incomes');
	}
}