<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmpInstallmentsTable extends Migration {

	public function up()
	{
		Schema::create('tmp_installments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('transaction_id')->nullable();
			$table->string('Instelemnt_id', 100)->nullable();
			$table->double('value')->nullable();
			$table->integer('jack_customer_id')->nullable();
			$table->integer('maak_customer_id')->nullable();
			$table->time('due_date')->nullable();
			$table->enum('Payment_status', array('paid', 'delaid', 'pending', 'dued'))->nullable();
			$table->date('Payment_date')->nullable();
			$table->double('Delay_fee')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tmp_installments');
	}
}