<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmpPayTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('tmp_pay_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('pay_customer_id')->nullable();
			$table->integer('reciver_id')->nullable();
			$table->integer('pay_card_id')->nullable();
			$table->double('amount')->nullable();
			$table->enum('type', array('transfer', 'pay'))->nullable();
			$table->boolean('is_reconciliation')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tmp_pay_transactions');
	}
}