<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalAgainstCompanyLawsuitsTable extends Migration {

	public function up()
	{
		Schema::create('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('lawsuit_number', 100);
			$table->bigInteger('court_id')->unsigned()->nullable();
			$table->integer('judicial_department_id')->unsigned();
			$table->date('lawsuit_upload_date');
			$table->enum('status', array('new', 'prossesing', 'ended'));
			$table->text('reason')->nullable();
			$table->double('judicial_fee')->nullable();
			$table->string('claimant_name', 100)->nullable();
			$table->string('claimant_identity', 100);
			$table->integer('customer_id')->unsigned();
			$table->integer('employee_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('legal_against_company_lawsuits');
	}
}