<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCompanyLawsuitExecutionsTable extends Migration {

	public function up()
	{
		Schema::create('legal_company_lawsuit_executions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('implementation_number', 100)->nullable();
			$table->string('implementation_department_number', 100)->nullable();
			$table->enum('payment', array('transferrequest', 'timelimitrequest', 'full', 'partial'))->nullable();
			$table->string('payment_order_number', 100);
		});
	}

	public function down()
	{
		Schema::drop('legal_company_lawsuit_executions');
	}
}