<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCompanyLawsuitsTable extends Migration {

	public function up()
	{
		Schema::create('legal_company_lawsuits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('isfailed_id')->unsigned()->nullable();
			$table->enum('status', array('New', 'ReconciliationCompleted', 'ReconciliationFailed'));
			$table->enum('implementation_status', array('accepted', 'incomplete'))->nullable();
			$table->integer('judicial_department_id')->unsigned();
			$table->string('judicial_request', 100)->nullable();
			$table->date('judicial_upload_date')->nullable();
			$table->string('lawsuit_number', 100)->nullable();
			$table->double('judicial_amount')->nullable();
			$table->double('judicial_fee')->nullable();
			$table->integer('execution_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('employee_id');
		});
	}

	public function down()
	{
		Schema::drop('legal_company_lawsuits');
	}
}