<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalConsultingsTable extends Migration {

	public function up()
	{
		Schema::create('legal_consultings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id')->unsigned()->nullable();
			$table->string('consulting_number', 100)->unique()->nullable();
			$table->string('name', 100)->nullable();
			$table->enum('type', array('consulting', 'template', 'editing'));
		});
	}

	public function down()
	{
		Schema::drop('legal_consultings');
	}
}